/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class MinecartHandler
implements IMinecartCollisionHandler {
    private static final float OPTIMAL_DISTANCE = 1.28f;
    private static final float COEF_SPRING = 0.2f;
    private static final float COEF_SPRING_PLAYER = 0.5f;
    private static final float COEF_RESTITUTION = 0.2f;
    private static final float COEF_DAMPING = 0.4f;
    private static final float CART_LENGTH = 1.22f;
    private static final float CART_WIDTH = 0.98f;
    private static final float COLLISION_EXPANSION = 0.2f;
    private static final int MAX_INTERACT_DIST_SQ = 25;

    public void onEntityCollision(AbstractMinecart cart, Entity other) {
        List<AbstractMinecart> carts;
        Player otherPlayer;
        Level level = cart.m_9236_();
        if (level.m_5776_() || cart.m_20363_(other) || !other.m_6084_() || !cart.m_6084_()) {
            return;
        }
        RollingStock rollingStock = RollingStock.getOrThrow(cart);
        AbstractMinecart link = rollingStock.backLink().map(RollingStock::entity).orElse(null);
        if (link != null && (link == other || link.m_20363_(other))) {
            return;
        }
        link = rollingStock.frontLink().map(RollingStock::entity).orElse(null);
        if (link != null && (link == other || link.m_20363_(other))) {
            return;
        }
        boolean isLiving = other instanceof LivingEntity;
        boolean isPlayer = other instanceof Player;
        if (other instanceof Player && (otherPlayer = (Player)other).m_5833_()) {
            return;
        }
        if (other instanceof AbstractMinecart) {
            AbstractMinecart otherCart = (AbstractMinecart)other;
            rollingStock.tryAutoLink(RollingStock.getOrThrow(otherCart));
        }
        this.testHighSpeedCollision(rollingStock, other);
        if (isLiving && level.m_8055_(cart.m_20183_()).m_60713_((Block)RailcraftBlocks.ELEVATOR_TRACK.get()) && other.m_20191_().f_82289_ < cart.m_20191_().f_82292_) {
            other.m_6478_(MoverType.SELF, new Vec3(0.0, cart.m_20191_().f_82292_ - other.m_20191_().f_82289_, 0.0));
            other.m_6853_(true);
        }
        if (level.m_213780_().m_188501_() < 0.001f && (carts = EntitySearcher.findMinecarts().around((Entity)cart).and(EntitySelector.f_20402_, ModEntitySelector.NON_MECHANICAL).list(level)).size() >= 12) {
            rollingStock.primeExplosion();
        }
        Vec3 cartMotion = cart.m_20184_();
        if (isLiving && !isPlayer && cart.canBeRidden() && !(other instanceof IronGolem) && cartMotion.m_7096_() * cartMotion.m_7096_() + cartMotion.m_7094_() * cartMotion.m_7094_() > 0.001 && !cart.m_20160_() && !other.m_20159_() && rollingStock.isMountable()) {
            other.m_20329_((Entity)cart);
        }
        if (isLiving && level.m_8055_(cart.m_20183_()).m_60713_((Block)RailcraftBlocks.ELEVATOR_TRACK.get())) {
            return;
        }
        Vector2d sub = new Vector2d(other.m_20185_(), other.m_20189_()).sub(cart.m_20185_(), cart.m_20189_());
        Vector2d unit = sub.equals(0.0, 0.0) ? sub : sub.normalize();
        double distance = cart.m_20270_(other);
        double depth = distance - (double)1.28f;
        double forceX = 0.0;
        double forceZ = 0.0;
        if (depth < 0.0) {
            double spring = isPlayer ? 0.5 : (double)0.2f;
            double penaltyX = spring * depth * unit.x();
            double penaltyZ = spring * depth * unit.y();
            forceX += penaltyX;
            forceZ += penaltyZ;
            if (!isPlayer) {
                double impulseX = unit.x();
                double impulseZ = unit.y();
                impulseX *= -1.2000000029802322;
                impulseZ *= -1.2000000029802322;
                Vector2d cartVel = new Vector2d(cart.m_20184_().m_7096_(), cart.m_20184_().m_7094_());
                Vector2d otherVel = new Vector2d(other.m_20184_().m_7096_(), other.m_20184_().m_7094_());
                double dot = otherVel.sub((Vector2dc)cartVel).dot((Vector2dc)unit);
                impulseX *= dot;
                impulseZ *= dot;
                forceX -= (impulseX *= 0.5);
                forceZ -= (impulseZ *= 0.5);
            }
        }
        if (other instanceof AbstractMinecart) {
            AbstractMinecart otherCart = (AbstractMinecart)other;
            if (!(cart.isPoweredCart() && !otherCart.isPoweredCart() || TrackUtil.isCartLocked(cart))) {
                cart.m_20256_(cart.m_20184_().m_82520_(forceX, 0.0, forceZ));
            }
            if (!(otherCart.isPoweredCart() && !cart.isPoweredCart() || TrackUtil.isCartLocked(otherCart))) {
                other.m_20256_(other.m_20184_().m_82520_(-forceX, 0.0, -forceZ));
            }
        } else {
            Vector2d cartVel = new Vector2d(cart.m_20184_().m_7096_(), cart.m_20184_().m_7094_()).add(forceX, forceZ);
            Vector2d otherVel = new Vector2d(other.m_20184_().m_7096_(), other.m_20184_().m_7094_()).sub(forceX, forceZ);
            double dot = otherVel.sub((Vector2dc)cartVel).dot((Vector2dc)unit);
            double dampX = (double)0.4f * dot * unit.x();
            double dampZ = (double)0.4f * dot * unit.y();
            forceX += dampX;
            forceZ += dampZ;
            if (!isPlayer) {
                other.m_20256_(other.m_20184_().m_82520_(-forceX, 0.0, -forceZ));
            }
            if (!TrackUtil.isCartLocked(cart)) {
                cart.m_20256_(cart.m_20184_().m_82520_(forceX, 0.0, forceZ));
            }
        }
    }

    private void testHighSpeedCollision(RollingStock rollingStock, Entity other) {
        AbstractMinecart cart = rollingStock.entity();
        if (rollingStock.isHighSpeed()) {
            boolean otherHighSpeed;
            RollingStock otherExtension;
            if (other instanceof AbstractMinecart) {
                AbstractMinecart otherCart = (AbstractMinecart)other;
                v0 = RollingStock.getOrThrow(otherCart);
            } else {
                v0 = otherExtension = null;
            }
            if (otherExtension != null && rollingStock.isSameTrainAs(otherExtension)) {
                return;
            }
            if (rollingStock.train().entities().anyMatch(c -> c.m_20363_(other))) {
                return;
            }
            if (otherExtension != null && (!(otherHighSpeed = otherExtension.isHighSpeed()) || cart.m_20184_().m_7096_() > 0.0 ^ other.m_20184_().m_7096_() > 0.0 || cart.m_20184_().m_7094_() > 0.0 ^ other.m_20184_().m_7094_() > 0.0)) {
                rollingStock.primeExplosion();
                return;
            }
            if (!other.m_6084_() || ((List)RailcraftConfig.SERVER.highSpeedTrackIgnoredEntities.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)other.m_6095_()).toString())) {
                return;
            }
            rollingStock.primeExplosion();
        }
    }

    @Nullable
    public AABB getCollisionBox(AbstractMinecart cart, Entity other) {
        if (other instanceof ItemEntity && ((Boolean)RailcraftConfig.SERVER.cartsCollideWithItems.get()).booleanValue()) {
            return other.m_20191_().m_82400_(-0.01);
        }
        return other.m_6094_() ? other.m_20191_().m_82400_((double)-0.2f) : null;
    }

    public AABB getMinecartCollisionBox(AbstractMinecart cart) {
        double yaw = Math.toRadians(cart.m_146908_());
        double diff = 0.3200000077486038;
        double x = diff * Math.abs(Math.cos(yaw));
        double z = diff * Math.abs(Math.sin(yaw));
        return cart.m_20191_().m_82377_(x, (double)0.2f, z);
    }

    @Nullable
    public AABB getBoundingBox(AbstractMinecart cart) {
        if (cart == null || !cart.m_6084_()) {
            return null;
        }
        if (((Boolean)RailcraftConfig.SERVER.solidCarts.get()).booleanValue()) {
            return cart.m_20191_();
        }
        return null;
    }

    public boolean handleInteract(AbstractMinecart cart, Player player) {
        if (!(cart instanceof TunnelBore) && player.m_20280_((Entity)cart) > 25.0) {
            return true;
        }
        if (!cart.m_6084_()) {
            return true;
        }
        if (cart.canBeRidden()) {
            if (player.m_20202_() != null && player.m_20202_() != cart) {
                return true;
            }
            if (player.m_20202_() != cart && player.m_6147_()) {
                return true;
            }
        }
        return !player.m_142582_((Entity)cart);
    }
}

