/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.routing.expression.condition;

import java.util.Locale;
import java.util.function.Predicate;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.util.routing.RoutingStatementParser;
import mods.railcraft.util.routing.expression.Expression;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class LocomotiveCondition {
    public static final String KEYWORD = "Loco";

    public static Expression parse(String line) throws RoutingLogicException {
        RoutingStatementParser.ParsedStatement statement = RoutingStatementParser.parse(KEYWORD, false, line);
        Predicate<Locomotive> predicate = switch (statement.value().toLowerCase(Locale.ROOT)) {
            case "electric" -> loco -> loco.m_6095_() == RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get();
            case "steam" -> loco -> loco.m_6095_() == RailcraftEntityTypes.STEAM_LOCOMOTIVE.get();
            case "creative" -> loco -> loco.m_6095_() == RailcraftEntityTypes.CREATIVE_LOCOMOTIVE.get();
            case "none" -> null;
            default -> throw new IllegalArgumentException("Unexpected value: " + statement.value());
        };
        return (router, rollingStock) -> {
            AbstractMinecart patt1236$temp = rollingStock.entity();
            if (patt1236$temp instanceof Locomotive) {
                Locomotive loco = (Locomotive)patt1236$temp;
                if (predicate != null) {
                    return predicate.test(loco);
                }
            }
            return true;
        };
    }
}

