/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.routing;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.util.container.ForwardingContainer;
import mods.railcraft.util.routing.RoutingLogic;
import mods.railcraft.util.routing.RoutingLogicException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.MenuProvider;
import org.jetbrains.annotations.Nullable;

public interface RouterBlockEntity
extends MenuProvider,
ForwardingContainer {
    public boolean isPowered();

    public void neighborChanged();

    public Railway getRailway();

    public void setRailway(@Nullable GameProfile var1);

    public Optional<Either<RoutingLogic, RoutingLogicException>> logicResult();

    default public Optional<RoutingLogic> logic() {
        return this.logicResult().flatMap(x -> x.left());
    }

    default public Optional<RoutingLogicException> logicError() {
        return this.logicResult().flatMap(x -> x.right());
    }

    public void resetLogic();

    default public Deque<String> loadPages(CompoundTag tag) {
        LinkedList<String> contents = new LinkedList<String>();
        ListTag pages = tag.m_128437_("pages", 8).m_6426_();
        for (int i = 0; i < pages.size(); ++i) {
            String[] page = pages.m_128778_(i).split("\n");
            contents.addAll(Arrays.asList(page));
        }
        return contents;
    }

    public static enum Railway implements ButtonState<Railway>,
    StringRepresentable
    {
        PUBLIC("public"),
        PRIVATE("private");

        private static final StringRepresentable.EnumCodec<Railway> CODEC;
        private final String name;

        private Railway(String name) {
            this.name = name;
        }

        @Override
        public Component label() {
            return Component.m_237115_((String)Translations.makeKey("screen", String.format("router_block_entity.%s_railway", this.name)));
        }

        @Override
        public TexturePosition texturePosition() {
            return ButtonTexture.SMALL_BUTTON;
        }

        @Override
        public Railway next() {
            return (Railway)EnumUtil.next((Enum)this, (Enum[])Railway.values());
        }

        public String m_7912_() {
            return this.name;
        }

        public static Railway fromName(String name) {
            return (Railway)CODEC.m_262792_(name, (Enum)PUBLIC);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Railway::values);
        }
    }
}

