/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.play;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mods.railcraft.world.inventory.RailcraftMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record SyncWidgetMessage(int windowId, byte widgetId, FriendlyByteBuf data) {
    public void encode(FriendlyByteBuf out) {
        out.m_130130_(this.windowId);
        out.writeByte((int)this.widgetId);
        out.m_130130_(this.data.readableBytes());
        out.writeBytes((ByteBuf)this.data);
    }

    public static SyncWidgetMessage decode(FriendlyByteBuf in) {
        return new SyncWidgetMessage(in.m_130242_(), in.readByte(), new FriendlyByteBuf(in.readBytes(in.m_130242_())));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        SyncWidgetMessage.processOnClient(this);
        return true;
    }

    private static void processOnClient(SyncWidgetMessage message) {
        Minecraft minecraft = Minecraft.m_91087_();
        AbstractContainerMenu menu = minecraft.f_91074_.f_36096_;
        if (menu instanceof RailcraftMenu) {
            RailcraftMenu railcraftMenu = (RailcraftMenu)menu;
            if (menu.f_38840_ == message.windowId) {
                railcraftMenu.getWidgets().get(message.widgetId).readFromBuf(message.data);
                message.data.release();
            }
        }
    }
}

