/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceRecipeCategory
implements IRecipeCategory<BlastFurnaceRecipe> {
    public static final int WIDTH = 82;
    public static final int HEIGHT = 54;
    public static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/blast_furnace.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable flame;
    private final IDrawable arrow;

    public BlastFurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 55, 16, 82, 54);
        ItemStack itemStack = new ItemStack((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get());
        this.icon = guiHelper.createDrawableItemStack(itemStack);
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(BACKGROUND, 176, 0, 14, 14), 200, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(BACKGROUND, 177, 14, 22, 15), 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<BlastFurnaceRecipe> getRecipeType() {
        return RecipeTypes.BLAST_FURNACE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)Translations.Jei.BLAST_FURNACE);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(BlastFurnaceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 1, 20);
        this.arrow.draw(guiGraphics, 25, 19);
        int cookTime = recipe.m_43753_();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font font = Minecraft.m_91087_().f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(font, (Component)timeString, this.getBackground().getWidth() - stringWidth - 30, 45, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlastFurnaceRecipe recipe, IFocusGroup focuses) {
        NonNullList ingredients = recipe.m_7527_();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)ingredients.get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 5).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 37).addItemStack(new ItemStack((ItemLike)RailcraftItems.SLAG.get(), recipe.getSlagOutput()));
    }
}

