/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class RenderUtil {
    public static final int FULL_LIGHT = 0xF000F0;
    public static final float PIXEL = 0.0625f;
    public static final float SCALED_PIXEL = 0.00390625f;
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public static int replaceAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static int getColorARGB(FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = RenderUtil.getColorARGB(fluidStack);
        if (fluidStack.getFluid().getFluidType().isLighterThanAir()) {
            int alpha = (int)(Math.min(1.0f, fluidScale + 0.2f) * 255.0f);
            return FastColor.ARGB32.m_13660_((int)alpha, (int)FastColor.ARGB32.m_13665_((int)color), (int)FastColor.ARGB32.m_13667_((int)color), (int)FastColor.ARGB32.m_13669_((int)color));
        }
        return color;
    }

    public static int getColorARGB(FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int calculateGlowLight(int combinedLight, FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : RenderUtil.calculateGlowLight(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static void renderBlockHoverText(BlockPos blockPos, Component text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (RenderUtil.minecraft.f_91077_ != null && RenderUtil.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)RenderUtil.minecraft.f_91077_).m_82425_().equals((Object)blockPos)) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 1.5f, 0.5f);
            RenderUtil.renderWorldText(RenderUtil.minecraft.f_91062_, text, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }

    public static void renderWorldText(Font font, Component text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(RenderUtil.minecraft.f_91063_.m_109153_().m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float backgroundOpacity = RenderUtil.minecraft.f_91066_.m_92141_(0.25f);
        int packedOverlay = (int)(backgroundOpacity * 255.0f) << 24;
        float x = -font.m_92852_((FormattedText)text) / 2;
        font.m_272077_(text, x, 0.0f, 0x20FFFFFF, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, packedOverlay, packedLight);
        font.m_272077_(text, x, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }
}

