/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.model;

import com.google.common.collect.Sets;
import java.util.Set;
import mods.railcraft.api.core.RailcraftConstants;
import net.minecraft.client.model.geom.ModelLayerLocation;

public class RailcraftModelLayers {
    private static final Set<ModelLayerLocation> allModels = Sets.newHashSet();
    public static final ModelLayerLocation ELECTRIC_LOCOMOTIVE = RailcraftModelLayers.register("electric_locomotive");
    public static final ModelLayerLocation ELECTRIC_LOCOMOTIVE_SNOW = RailcraftModelLayers.register("electric_locomotive_snow");
    public static final ModelLayerLocation STEAM_LOCOMOTIVE = RailcraftModelLayers.register("steam_locomotive");
    public static final ModelLayerLocation STEAM_LOCOMOTIVE_SNOW = RailcraftModelLayers.register("steam_locomotive_snow");
    public static final ModelLayerLocation LOW_SIDES_MINECART = RailcraftModelLayers.register("low_sides_minecart");
    public static final ModelLayerLocation LOW_SIDES_MINECART_SNOW = RailcraftModelLayers.register("low_sides_minecart_snow");
    public static final ModelLayerLocation ELECTRIC_LOCOMOTIVE_LAMP = RailcraftModelLayers.register("electric_locomotive_lamp");
    public static final ModelLayerLocation MAINTENANCE_LAMP = RailcraftModelLayers.register("maintenance_lamp");
    public static final ModelLayerLocation MAINTENANCE = RailcraftModelLayers.register("maintenance");
    public static final ModelLayerLocation TUNNEL_BORE = RailcraftModelLayers.register("tunnel_bore");
    public static final ModelLayerLocation MINECART_SNOW = RailcraftModelLayers.register("minecart_snow");
    public static final ModelLayerLocation CUBE = RailcraftModelLayers.register("cube");

    private static ModelLayerLocation register(String model) {
        return RailcraftModelLayers.register(model, "main");
    }

    private static ModelLayerLocation register(String model, String layer) {
        ModelLayerLocation layerLocation = new ModelLayerLocation(RailcraftConstants.rl(model), layer);
        if (!allModels.add(layerLocation)) {
            throw new IllegalStateException("Duplicate registration for " + layerLocation);
        }
        return layerLocation;
    }
}

