/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.container.manipulator;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerSlotAccessor<T extends Container>
implements ModifiableSlotAccessor {
    protected final T container;
    protected final int index;

    private ContainerSlotAccessor(T container, int index) {
        this.container = container;
        this.index = index;
    }

    @Override
    public ItemStack item() {
        return this.container.m_8020_(this.index);
    }

    @Override
    public void setItem(ItemStack stack) {
        this.container.m_6836_(this.index, stack);
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return this.container.m_7013_(this.index, stack);
    }

    @Override
    public ItemStack extract(int amount, boolean simulate) {
        if (simulate) {
            return this.item().m_41777_().m_41620_(amount);
        }
        return this.container.m_7407_(this.index, amount);
    }

    @Override
    public ItemStack insert(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.container.m_7013_(this.index, stack)) {
            return stack;
        }
        ItemStack currentItem = this.item();
        if (!currentItem.m_41619_()) {
            if (currentItem.m_41613_() >= Math.min(currentItem.m_41741_(), this.maxStackSize())) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentItem)) {
                return stack;
            }
        }
        int insertable = Math.min(stack.m_41741_(), this.maxStackSize()) - currentItem.m_41613_();
        stack = stack.m_41777_();
        if (simulate) {
            stack.m_41774_(insertable);
        } else {
            ItemStack copy = stack.m_41620_(insertable);
            if (currentItem.m_41613_() > 0) {
                copy.m_41769_(currentItem.m_41613_());
            }
            this.container.m_6836_(this.index, copy);
            this.container.m_6596_();
        }
        return stack.m_41619_() ? ItemStack.f_41583_ : stack;
    }

    @Override
    public int maxStackSize() {
        return this.container.m_6893_();
    }

    public static Stream<ModifiableSlotAccessor> createSlots(Container container) {
        return ContainerSlotAccessor.createSlots(container, 0, container.m_6643_());
    }

    public static Stream<ModifiableSlotAccessor> createSlots(Container container, int start, int size) {
        return IntStream.range(start, size).mapToObj(i -> new ContainerSlotAccessor<Container>(container, i));
    }

    public static Stream<ModifiableSlotAccessor> createSlots(WorldlyContainer container, Direction face) {
        return Arrays.stream(container.m_7071_(face)).mapToObj(i -> new Worldly(container, i, face));
    }

    public static class Worldly
    extends ContainerSlotAccessor<WorldlyContainer> {
        private final Direction face;

        private Worldly(WorldlyContainer container, int index, Direction face) {
            super(container, index);
            this.face = face;
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return ((WorldlyContainer)this.container).m_7155_(this.index, itemStack, this.face);
        }

        @Override
        public ItemStack extract(int amount, boolean simulate) {
            return ((WorldlyContainer)this.container).m_7157_(this.index, this.item(), this.face) ? super.extract(amount, simulate) : ItemStack.f_41583_;
        }
    }
}

