/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.fuel.FuelUtil;
import mods.railcraft.charge.ChargeCartStorageImpl;
import mods.railcraft.charge.ChargeProviderImpl;
import mods.railcraft.charge.ZapEffectProviderImpl;
import mods.railcraft.client.ClientManager;
import mods.railcraft.data.RailcraftBlockTagsProvider;
import mods.railcraft.data.RailcraftDamageTypeTagsProvider;
import mods.railcraft.data.RailcraftDatapackProvider;
import mods.railcraft.data.RailcraftFluidTagsProvider;
import mods.railcraft.data.RailcraftItemTagsProvider;
import mods.railcraft.data.RailcraftLanguageProvider;
import mods.railcraft.data.RailcraftPoiTypeTagsProvider;
import mods.railcraft.data.RailcraftSoundsProvider;
import mods.railcraft.data.RailcraftSpriteSourceProvider;
import mods.railcraft.data.advancements.RailcraftAdvancementProvider;
import mods.railcraft.data.loot.RailcraftLootModifierProvider;
import mods.railcraft.data.loot.RailcraftLootTableProvider;
import mods.railcraft.data.models.RailcraftBlockModelProvider;
import mods.railcraft.data.models.RailcraftItemModelProvider;
import mods.railcraft.data.recipes.RailcraftRecipeProvider;
import mods.railcraft.data.recipes.builders.BrewingRecipe;
import mods.railcraft.fuel.FuelManagerImpl;
import mods.railcraft.loot.RailcraftLootModifiers;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.network.play.LinkedCartsMessage;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.capability.CapabilityUtil;
import mods.railcraft.util.fluids.CreosoteBottleWrapper;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.effect.RailcraftMobEffects;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.ai.village.poi.RailcraftPoiTypes;
import mods.railcraft.world.entity.npc.RailcraftVillagerProfession;
import mods.railcraft.world.entity.npc.RailcraftVillagerTrades;
import mods.railcraft.world.entity.vehicle.MinecartHandler;
import mods.railcraft.world.entity.vehicle.RollingStockImpl;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.ChargeMeterItem;
import mods.railcraft.world.item.CrowbarHandler;
import mods.railcraft.world.item.RailcraftCreativeModeTabs;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.alchemy.RailcraftPotions;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.item.enchantment.RailcraftEnchantments;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.track.TrackTypes;
import mods.railcraft.world.level.gameevent.RailcraftGameEvents;
import mods.railcraft.world.level.levelgen.structure.ComponentWorkshop;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructurePieces;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructureTypes;
import mods.railcraft.world.level.material.RailcraftFluidTypes;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.signal.TokenRingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="railcraft")
public class Railcraft {
    public static final boolean BETA = true;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecartHandler minecartHandler = new MinecartHandler();

    public Railcraft() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        RailcraftConfig.registerConfig(ModLoadingContext.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::buildContents);
        modEventBus.addListener(this::handleGatherData);
        if (FMLEnvironment.dist.isClient()) {
            ClientManager.init(modEventBus);
        }
        RailcraftEntityTypes.register(modEventBus);
        RailcraftBlocks.register(modEventBus);
        RailcraftItems.register(modEventBus);
        RailcraftPotions.register(modEventBus);
        RailcraftMobEffects.register(modEventBus);
        RailcraftCreativeModeTabs.register(modEventBus);
        RailcraftBlockEntityTypes.register(modEventBus);
        TrackTypes.register(modEventBus);
        RailcraftFluids.register(modEventBus);
        RailcraftFluidTypes.register(modEventBus);
        RailcraftMenuTypes.register(modEventBus);
        RailcraftSoundEvents.register(modEventBus);
        RailcraftEnchantments.register(modEventBus);
        RailcraftParticleTypes.register(modEventBus);
        RailcraftRecipeSerializers.register(modEventBus);
        RailcraftRecipeTypes.register(modEventBus);
        RailcraftGameEvents.register(modEventBus);
        RailcraftDataSerializers.register(modEventBus);
        RailcraftPoiTypes.register(modEventBus);
        RailcraftVillagerProfession.register(modEventBus);
        RailcraftLootModifiers.register(modEventBus);
        RailcraftStructureTypes.register(modEventBus);
        RailcraftStructurePieces.register(modEventBus);
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        NetworkChannel.registerAll();
        event.enqueueWork(() -> {
            RailcraftCriteriaTriggers.register();
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Potions.f_43602_, (Item)RailcraftItems.CREOSOTE_BOTTLE.get(), (Potion)RailcraftPotions.CREOSOTE.get()));
            ForgeChunkManager.setForcedChunkLoadingCallback((String)"railcraft", (level, ticketHelper) -> {
                int tickingTicketCount;
                int ticketCount;
                Pair value;
                Object key;
                for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
                    key = (BlockPos)entry.getKey();
                    value = (Pair)entry.getValue();
                    ticketCount = ((LongSet)value.getFirst()).size();
                    tickingTicketCount = ((LongSet)value.getSecond()).size();
                    BlockEntity be = level.m_7702_(key);
                    if (be instanceof WorldSpikeBlockEntity) {
                        LOGGER.info("Allowing {} chunk tickets and {} ticking chunk tickets to be reinstated for position: {}.", new Object[]{ticketCount, tickingTicketCount, key});
                        continue;
                    }
                    ticketHelper.removeAllTickets(key);
                    LOGGER.info("Removing {} chunk tickets and {} ticking chunk tickets for no longer valid position: {}.", new Object[]{ticketCount, tickingTicketCount, key});
                }
                for (Map.Entry entry : ticketHelper.getEntityTickets().entrySet()) {
                    key = (UUID)entry.getKey();
                    value = (Pair)entry.getValue();
                    ticketCount = ((LongSet)value.getFirst()).size();
                    tickingTicketCount = ((LongSet)value.getSecond()).size();
                    LOGGER.info("Allowing {} chunk tickets and {} ticking chunk tickets to be reinstated for entity: {}.", new Object[]{ticketCount, tickingTicketCount, key});
                }
            });
        });
        FuelUtil.fuelManager().addFuel(RailcraftTags.Fluids.CREOSOTE, 4800);
    }

    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            RailcraftCreativeModeTabs.addToolsAndUtilities((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries());
        } else if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            RailcraftCreativeModeTabs.addCombat((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries());
        }
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        RailcraftBlockTagsProvider blockTags = new RailcraftBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        CompletableFuture blockTagsLookup = blockTags.m_274426_();
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftItemTagsProvider(packOutput, lookupProvider, blockTagsLookup, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftFluidTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftAdvancementProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftPoiTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftLootModifierProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftDamageTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftBlockModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftSoundsProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftSpriteSourceProvider(packOutput, fileHelper));
    }

    @SubscribeEvent
    public void handleServerAboutToStart(ServerAboutToStartEvent event) {
        ComponentWorkshop.addVillageStructures(event.getServer().m_206579_());
    }

    @SubscribeEvent
    public void handleServerStarted(ServerStartedEvent event) {
        if (((Boolean)RailcraftConfig.SERVER.solidCarts.get()).booleanValue()) {
            AbstractMinecart.registerCollisionHandler((IMinecartCollisionHandler)this.minecartHandler);
        }
    }

    @SubscribeEvent
    public void handleAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)object;
            event.addCapability(RollingStockImpl.KEY, CapabilityUtil.serializableProvider(CompoundTag::new, () -> new RollingStockImpl(minecart), RollingStock.CAPABILITY));
        }
    }

    @SubscribeEvent
    public void handleAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.m_150930_(Items.f_42590_)) {
            event.addCapability(RailcraftConstants.rl("bottle_container"), (ICapabilityProvider)new CreosoteBottleWrapper(stack));
        }
    }

    @SubscribeEvent
    public void handleLevelTick(TickEvent.LevelTickEvent event) {
        ChargeProviderImpl[] chargeProviderImplArray = event.level;
        if (chargeProviderImplArray instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)chargeProviderImplArray;
            if (event.phase == TickEvent.Phase.END) {
                for (ChargeProviderImpl provider : ChargeProviderImpl.values()) {
                    provider.network(level).tick();
                }
                TokenRingManager.get(level).tick(level);
            }
        }
    }

    @SubscribeEvent
    public void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_19797_ % 20 == 0) {
                List<LinkedCartsMessage.LinkedCart> linkedCarts = EntitySearcher.findMinecarts().around((Entity)player2).inflate(32.0).stream(player2.m_9236_()).map(RollingStock::getOrThrow).map(LinkedCartsMessage.LinkedCart::new).toList();
                NetworkChannel.GAME.sendTo(new LinkedCartsMessage(linkedCarts), player2);
            }
        }
    }

    @SubscribeEvent
    public void handleEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart cart = (AbstractMinecart)entity;
            Player player = event.getEntity();
            InteractionHand hand = event.getHand();
            ItemStack stack = event.getItemStack();
            if (!stack.m_41619_() && stack.m_150930_((Item)RailcraftItems.CHARGE_METER.get())) {
                player.m_6674_(hand);
                if (!player.m_9236_().m_5776_()) {
                    cart.getCapability(ForgeCapabilities.ENERGY).filter(ChargeCartStorageImpl.class::isInstance).map(ChargeCartStorageImpl.class::cast).ifPresent(battery -> {
                        ChargeMeterItem.sendCartStat(player, cart.m_5446_(), battery);
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                    });
                }
            } else {
                event.setCanceled(this.minecartHandler.handleInteract(cart, player));
                InteractionResult crowbarActionResult = CrowbarHandler.handleInteract(cart, player, hand);
                if (crowbarActionResult.m_19077_()) {
                    event.setCanceled(true);
                    event.setCancellationResult(crowbarActionResult);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEntityLeaveWorld(EntityLeaveLevelEvent event) {
        AbstractMinecart cart;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractMinecart && !(cart = (AbstractMinecart)entity).m_9236_().m_5776_() && cart.m_213877_()) {
            RollingStock.getOrThrow(cart).removed(cart.m_146911_());
        }
    }

    @SubscribeEvent
    public void modifyDrops(LivingDropsEvent event) {
        Level level = event.getEntity().m_9236_();
        RegistryAccess registryAccess = level.m_9598_();
        if (event.getSource().equals((Object)RailcraftDamageSources.steam(registryAccess))) {
            RecipeManager recipeManager = level.m_7465_();
            for (ItemEntity entityItem : event.getDrops()) {
                ItemStack drop = entityItem.m_32055_();
                ItemStack cooked = recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{drop}), level).map(x -> x.m_8043_(registryAccess)).orElse(ItemStack.f_41583_);
                if (cooked.m_41619_() || !level.m_213780_().m_188499_()) continue;
                entityItem.m_32045_(new ItemStack((ItemLike)cooked.m_41720_(), drop.m_41613_()));
            }
        }
    }

    @SubscribeEvent
    public void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == RailcraftVillagerProfession.TRACKMAN.get()) {
            RailcraftVillagerTrades.addTradeForTrackman((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == RailcraftVillagerProfession.CARTMAN.get()) {
            RailcraftVillagerTrades.addTradeForCartman((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.f_35586_) {
            RailcraftVillagerTrades.addTradeForArmorer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.f_35598_) {
            RailcraftVillagerTrades.addTradeForToolSmith((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        }
    }

    @SubscribeEvent
    public void handleNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        event.getLevel().m_142346_(null, (GameEvent)RailcraftGameEvents.NEIGHBOR_NOTIFY.get(), event.getPos());
    }

    static {
        FuelUtil._setFuelManager(new FuelManagerImpl());
        Charge._setZapEffectProvider(new ZapEffectProviderImpl());
        for (ChargeProviderImpl value : ChargeProviderImpl.values()) {
            value.getCharge()._setProvider(value);
        }
    }
}

