/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.bioshroom;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.GiantBioshroomConfiguration;

public class GiantYellowBioshroomFeature
extends Feature<GiantBioshroomConfiguration> {
    public GiantYellowBioshroomFeature(Codec<GiantBioshroomConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GiantBioshroomConfiguration> context) {
        GiantBioshroomConfiguration bioshroomConfiguration = (GiantBioshroomConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int limbDirection = context.m_225041_().m_188503_(12);
        int height_main = context.m_225041_().m_188503_(bioshroomConfiguration.sizeVariation) + bioshroomConfiguration.minimumSize;
        if (!level.m_8055_(pos).m_247087_()) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            if (placeCheck == 0) {
                this.placeBase((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
                this.placeGlowingCaps((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration, height_main);
            }
            if (placeCheck == height_main) {
                this.placeCap((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            }
            if (placeCheck != height_main) {
                this.placeStemBlock((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeBase(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        Random random = new Random();
        int n = random.nextInt(5);
        int s = random.nextInt(5);
        int e = random.nextInt(5);
        int w = random.nextInt(5);
        if (n == 0) {
            this.placeRoot(level, pos.m_122012_(), randomSource, bioshroomConfiguration);
        }
        if (s == 0) {
            this.placeRoot(level, pos.m_122019_(), randomSource, bioshroomConfiguration);
        }
        if (e == 0) {
            this.placeRoot(level, pos.m_122029_(), randomSource, bioshroomConfiguration);
        }
        if (w == 0) {
            this.placeRoot(level, pos.m_122024_(), randomSource, bioshroomConfiguration);
        }
    }

    public void placeStemBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get()) || level.m_8055_(pos).m_60713_(Blocks.f_50440_) || level.m_8055_(pos).m_60713_(Blocks.f_50195_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.MYCOTOXIC_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.GLISTERING_NYLIUM.get()) || level.m_8055_(pos).m_60713_(Blocks.f_50699_) || level.m_8055_(pos).m_60713_(Blocks.f_50690_)) {
            level.m_7731_(pos, Blocks.f_50134_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.COBALT_NYLIUM.get())) {
            level.m_7731_(pos, Blocks.f_50730_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PRISMOSS.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.STONE_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50069_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.DEEPSLATE_PRISMOSS.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.DEEPSLATE_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_152550_.m_49966_(), 2);
        } else if (GiantYellowBioshroomFeature.isReplaceable((LevelSimulatedReader)level, pos) || level.m_8055_(pos).m_60713_(bioshroomConfiguration.capProvider.m_213972_(randomSource, pos).m_60734_()) || level.m_8055_(pos).m_60713_(bioshroomConfiguration.glowBlockProvider.m_213972_(randomSource, pos).m_60734_())) {
            level.m_7731_(pos, bioshroomConfiguration.stemProvider.m_213972_(randomSource, pos), 2);
        } else {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get()) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50195_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.MYCOTOXIC_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.GLISTERING_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50699_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50690_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50134_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.COBALT_NYLIUM.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50730_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PRISMOSS.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.STONE_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50069_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.DEEPSLATE_PRISMOSS.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.DEEPSLATE_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_152550_.m_49966_(), 2);
        }
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        int rd = 2;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (i > 0 && !level.m_8055_(placePos.m_7494_()).m_60713_(bioshroomConfiguration.stemProvider.m_213972_(randomSource, placePos.m_7494_()).m_60734_()) && level.m_8055_((BlockPos)placePos).m_247087_()) {
                return;
            }
            this.placeStemBlock(level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public void placeCap(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        Random random = new Random();
        this.placeCapBlock(level, pos, randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122013_(2), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122013_(2).m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122013_(2).m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122020_(2), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122020_(2).m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122020_(2).m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122030_(2), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122030_(2).m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122030_(2).m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122025_(2), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122025_(2).m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122025_(2).m_122019_(), randomSource, bioshroomConfiguration);
        if (randomSource.m_188503_(2) == 0) {
            this.placeCapBlock(level, pos.m_122013_(2).m_122030_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122013_(2).m_122025_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(2).m_122030_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(2).m_122025_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122013_(3), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122013_(3).m_122029_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122013_(3).m_122024_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122013_(3).m_122030_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122013_(3).m_122025_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(3), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(3).m_122029_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(3).m_122024_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(3).m_122030_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122020_(3).m_122025_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122030_(3), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122030_(3).m_122012_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122030_(3).m_122019_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122030_(3).m_122013_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122030_(3).m_122020_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122025_(3), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122025_(3).m_122012_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122025_(3).m_122019_(), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122025_(3).m_122013_(2), randomSource, bioshroomConfiguration);
            this.placeCapBlock(level, pos.m_122025_(3).m_122020_(2), randomSource, bioshroomConfiguration);
        }
    }

    public void placeGlowingCaps(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration, int i) {
        int chance = randomSource.m_188503_(3);
        int cap1 = randomSource.m_188503_(i - 4) + 3;
        BlockPos pos1 = new BlockPos(pos.m_123341_(), pos.m_123342_() + cap1, pos.m_123343_());
        int cap2 = randomSource.m_188503_(i - 4) + 3;
        BlockPos pos2 = new BlockPos(pos.m_123341_(), pos.m_123342_() + cap2, pos.m_123343_());
        int direction = randomSource.m_188503_(2);
        if (direction == 0) {
            if (chance == 1) {
                this.placeGlowingBlock(level, pos1.m_122012_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122029_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
            } else if (chance == 2) {
                this.placeGlowingBlock(level, pos2.m_122019_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122024_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
            } else {
                this.placeGlowingBlock(level, pos1.m_122012_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122029_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122019_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122024_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
            }
        } else if (direction == 1) {
            if (chance == 1) {
                this.placeGlowingBlock(level, pos1.m_122012_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122024_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
            } else if (chance == 2) {
                this.placeGlowingBlock(level, pos2.m_122019_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122029_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
            } else {
                this.placeGlowingBlock(level, pos1.m_122012_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122024_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos1.m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122019_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122029_(), randomSource, bioshroomConfiguration);
                this.placeGlowingBlock(level, pos2.m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
            }
        }
    }

    public void placeCapBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        if (level.m_151570_(pos)) {
            return;
        }
        if (GiantYellowBioshroomFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, bioshroomConfiguration.capProvider.m_213972_(randomSource, pos), 2);
        }
    }

    public void placeGlowingBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, bioshroomConfiguration.glowBlockProvider.m_213972_(randomSource, pos), 2);
        }
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, GiantYellowBioshroomFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, GiantYellowBioshroomFeature::isReplaceableBlock);
    }
}

